/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.downloader;

import com.aptana.core.epl.downloader.ConnectionData;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.ide.core.io.downloader.ContentDownloadRequest;
import com.aptana.ide.core.io.downloader.FileDownloadRequest;
import com.aptana.ide.core.io.downloader.Messages;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadManager {
    private List<ContentDownloadRequest> downloads;
    private List<IPath> completedDownloadsPaths;
    private ConnectionData connectData;

    public void addURL(URL url) throws CoreException {
        if (url != null) {
            try {
                this.addURI(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", e.getMessage(), (Throwable)e));
            }
        }
    }

    public void addURI(URI uri) throws CoreException {
        if (uri != null) {
            if ("file".equals(uri.getScheme())) {
                this.addDownload(new FileDownloadRequest(uri));
            } else {
                this.addDownload(new ContentDownloadRequest(uri));
            }
        }
    }

    public void addURI(URI uri, File saveTo) throws CoreException {
        if (uri != null) {
            if ("file".equals(uri.getScheme())) {
                this.addDownload(new FileDownloadRequest(uri, saveTo));
            } else {
                this.addDownload(new ContentDownloadRequest(uri, saveTo));
            }
        }
    }

    public synchronized void addDownload(ContentDownloadRequest request) {
        if (this.downloads == null) {
            this.downloads = new ArrayList<ContentDownloadRequest>(2);
        }
        this.downloads.add(request);
    }

    public void addURIs(List<URI> uris) throws CoreException {
        if (!CollectionsUtil.isEmpty(uris)) {
            for (URI uri : uris) {
                this.addURI(uri);
            }
        }
    }

    public IStatus start(IProgressMonitor monitor) {
        if (CollectionsUtil.isEmpty(this.downloads)) {
            return Status.OK_STATUS;
        }
        try {
            IStatus iStatus = this.download(monitor);
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void setConnectionData(ConnectionData connectData) {
        this.connectData = connectData;
    }

    protected IStatus download(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DownloadManager_downloadingContent, (int)this.downloads.size());
        MultiStatus multi = new MultiStatus("com.aptana.core.io", 0, null, null);
        this.completedDownloadsPaths = new ArrayList<IPath>(this.downloads.size());
        Iterator<ContentDownloadRequest> iterator = this.downloads.iterator();
        while (iterator.hasNext()) {
            if (subMonitor.isCanceled()) {
                multi.add(Status.CANCEL_STATUS);
                return multi;
            }
            ContentDownloadRequest request = iterator.next();
            request.execute(this.connectData, (IProgressMonitor)subMonitor.newChild(1));
            IStatus result = request.getResult();
            if (result != null) {
                if (result.isOK()) {
                    this.completedDownloadsPaths.add(request.getDownloadLocation());
                    iterator.remove();
                }
                multi.add(result);
            }
            subMonitor.setWorkRemaining(this.downloads.size());
        }
        return multi;
    }

    public List<IPath> getContentsLocations() {
        return Collections.unmodifiableList(CollectionsUtil.getListValue(this.completedDownloadsPaths));
    }
}

